/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

public class ScheduleMenuVo extends MosPVo {

	private static final long serialVersionUID = 1473050564230241352L;

	// URL
	private static final String RETURN_URL = "/jsp/kintai/scheduleMenu.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/scheduleMenu.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/scheduleMenu.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_SCHEDULE;

	public final String CMD_SCHEDULE_MENU 		= "K1200";
	public final String TTL_SCHEDULE_MENU 		= CommonConst.TTL_SCHEDULE;

	public final String CMD_SCHEDULE_CONFIRM_SEARCH 	= "K1232";
	public final String TTL_SCHEDULE_CONFIRM 			= CommonConst.TTL_SCHEDULE_CONFIRM;

	public final String CMD_SCHEDULE_EDIT_SEARCH 		= "K1242";
	public final String TTL_SCHEDULE_EDIT 				= CommonConst.TTL_SCHEDULE_EDIT;

	// p[^
	public static final String PRM_PLT_YEAR  = "pltYear";
	public static final String PRM_PLT_MONTH = "pltMonth";

	// tB[h
	private String selectKCode;
	private String selectKName;
	private String selectSectionName;

	private String pltYear;
	private String pltMonth;

	/**
	 * RXgN^
	 */
	public ScheduleMenuVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		pltYear  			= "";
		pltMonth 			= "";
		selectKCode 		= "";
		selectKName 		= "";
		selectSectionName 	= "";
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltYear  = request.getParameter(PRM_PLT_YEAR );
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}

	// ANZT\bh
	public String getPltYear             () { return pltYear                      ; }
	public String getPltMonth            () { return pltMonth                     ; }
	public String getEscPltYear          () { return escapeHTML(pltYear)          ; }
	public String getEscPltMonth         () { return escapeHTML(pltMonth)         ; }

	public String getSelectKCode         () { return selectKCode                  ; }
	public String getSelectKName         () { return selectKName                  ; }
	public String getSelectSectionName   () { return selectSectionName            ; }
	public String getEscSelectKCode      () { return escapeHTML(selectKCode)      ; }
	public String getEscSelectKName      () { return escapeHTML(selectKName)      ; }
	public String getEscSelectSectionName() { return escapeHTML(selectSectionName); }

	public void setSelectKCode      (String selectKCode      ) { this.selectKCode       = selectKCode      ; }
	public void setSelectKName      (String selectKName      ) { this.selectKName       = selectKName      ; }
	public void setSelectSectionName(String selectSectionName) { this.selectSectionName = selectSectionName; }

	public void setPltYear          (String pltYear          ) { this.pltYear           = pltYear          ; }
	public void setPltMonth         (String pltMonth         ) { this.pltMonth          = pltMonth         ; }

}
